﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie miesięczne dla deklaracji PIT 4R i PIT 8AR</title>
		<script runat="server">
  
            class ElementWyplaty {
                public ElementWyplaty(string nazwa, int numer, WypElement element) {
                    PozycjaPIT pozpit = element.Definicja.Deklaracje.PozycjaPIT;
                    string opis = pozpit.Opis;
                    string elem = element.Nazwa;
                    numer /= 10;
                    if (nazwa == "PIT-8AR" && !pozpit.Kod.Contains(nazwa)) {
                        if (pozpit.Kod == "PIT-11 6/PIT-4R 3.") {
                            opis = "PIT-8AR 6. Należności z tytułu, o którym mowa w art. 13 pkt 2 i 5-9 ustawy z umów zawartych z osobą niebędącą pracownikiem płatnika (art. 30 ust. 1 pkt 5a ustawy)";
                            numer = 6;
                        }
                        else {
                            opis = "PIT-8AR 13.Inne należności nie wymienione w wierszach 1-12";
                            elem = "PIT-8A.13.Inne należności";
                            numer = 13;
                        }
                    }
                    Nazwa = nazwa;
                    Numer = numer;
                    Opis = opis;
                    Kod = element.Pracownik.Kod;
                    NazwiskoImie = element.Pracownik.NazwiskoImię;
                    NrWyplaty = element.Wyplata.Numer.ToString();
                    Element = elem;
                    Przychod = (pozpit.Kod!="PIT-11 F.") ? element.DoOpodatkowania : element.Wartosc;
                    Koszty = element.Podatki.Koszty + element.Podatki.Koszty50;
                    Dochod = Przychod - Koszty;
                    Podatek = element.Podatki.ZalFIS;
                    if (element.MiesiacZUS != element.MiesiacDeklaracji) {
                        Zus = 0;
                        Przychod -= element.Podatki.PomnKosztyZUS;
                    } else
                        Zus = element.Podatki.PomnKosztyZUS;
                    Pobrane = element.Podatki.Zdrowotna.Prac;
                    Odliczone = element.Podatki.ZdrowotneDoOdliczenia;
                }
                      
                string nazwa;
                public string Nazwa {
                    get { return nazwa; }
                    set { nazwa = value; }
                }

                int numer;
                public int Numer {
                    get { return numer; }
                    set { numer = value; }
                }

                string opis;
                public string Opis {
                    get { return opis; }
                    set { opis = value; }
                }
                                
                string kod;
                public string Kod {
                    get { return kod; }
                    set { kod = value; }
                }

                string nazwiskoImie;
                public string NazwiskoImie {
                    get { return nazwiskoImie; }
                    set { nazwiskoImie = value; }
                }

                string nrWyplaty;
                public string NrWyplaty {
                    get { return nrWyplaty; }
                    set { nrWyplaty = value; }
                }

                string element;
                public string Element {
                    get { return element; }
                    set { element = value; }
                }

                decimal przychod;
                public decimal Przychod {
                    get { return przychod; }
                    set { przychod = value; }
                }
                
                decimal koszty;
                public decimal Koszty {
                    get { return koszty; }
                    set { koszty = value; }
                }

                decimal dochod;
                public decimal Dochod {
                    get { return dochod; }
                    set { dochod = value; }
                }
                
                decimal podatek;
                public decimal Podatek {
                    get { return podatek; }
                    set { podatek = value; }
                }
                
                decimal zus;
                public decimal Zus {
                    get { return zus; }
                    set { zus = value; }
                }
                
                decimal pobrane;
                public decimal Pobrane {
                    get { return pobrane; }
                    set { pobrane = value; }
                }
                
                decimal odliczone;
                public decimal Odliczone {
                    get { return odliczone; }
                    set { odliczone = value; }
                }
            }
  
            class ElementWyplatyComparer : IComparer<ElementWyplaty> {
                public int Compare(ElementWyplaty x, ElementWyplaty y) {
                    int result = x.Numer.CompareTo(y.Numer);                    
                    if (result == 0)
                        result = x.NazwiskoImie.CompareTo(y.NazwiskoImie);
                    return result;
                }
            }
            
            void OnContextLoad(Object sender, EventArgs e) {
                Row[] rows = (Row[])dc[typeof(Row[])];
                
                FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
                ReportHeader1["OKRES"] = okres.ToString();
                
                List<ElementWyplaty> pit4elem = new List<ElementWyplaty>();
                List<ElementWyplaty> pit8elem = new List<ElementWyplaty>();

                bool zdrowotnaDoOdliczenia = false;

                foreach (ListaPlac lista in rows){
                    zdrowotnaDoOdliczenia |= lista.DataWyplaty <= new Date(2021, 12, 31);
                    foreach (Wyplata wyplata in lista.Wyplaty)
                        foreach (WypElement element in wyplata.Elementy) {
                            PozycjaPIT pozpit = element.Definicja.Deklaracje.PozycjaPIT;
                            if ((pozpit == null) || (okres.ToYearMonth() != element.MiesiacDeklaracji))
                                continue;

                            if ((pozpit.PIT4R > 0 && element.ZaliczkaPodatku) || pozpit.Kod == "PIT-11 F.") {
                                ElementWyplaty elem = new ElementWyplaty("PIT-4R", pozpit.PIT4R, element);
                                pit4elem.Add(elem);
                            }
                            else if (pozpit.PIT8AR > 0 && element.Podatek) {
                                ElementWyplaty elem = new ElementWyplaty("PIT-8AR", pozpit.PIT8AR, element);
                                pit8elem.Add(elem);
                            }
                        }
                }

				if(!zdrowotnaDoOdliczenia){
                    colZdrowotnaDoOdliczenia1.Visible = false;
                    colZdrowotnaDoOdliczenia2.Visible = false;
					colZdrowotna1.Visible = true;
					colZdrowotna2.Visible = false;
					colZdrowotna3.Visible = true;
					colZdrowotna4.Visible = false;
                }
				else{
					colZdrowotna1.Visible = false;
					colZdrowotna2.Visible = true;
					colZdrowotna3.Visible = false;
					colZdrowotna4.Visible = true;
				}

                pit4elem.Sort(new ElementWyplatyComparer());
                Grid1.DataSource = pit4elem;

                pit8elem.Sort(new ElementWyplatyComparer());
                Grid2.DataSource = pit8elem;
            }
           
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaPIT" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zestawienie miesięczne dla deklaracji PIT 4R i PIT 8AR|</strong>Okres: <strong>%OKRES%|Wykonany wg daty wypłaty" runat="server"></cc1:reportheader>
            <font face="Tahoma" size="2"><b>PIT 4R</b></font>
            <ea:Grid id="Grid1" runat="server" DataMember="DataSource" GroupData0="Opis" GroupLine="{0}" ShowGroupSum="true" ColumnTextFontSize="10">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="Lp."></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Left" VAlign="Top" DataMember="Kod" Caption="Kod"></ea:GridColumn>
                    <ea:GridColumn Width="25" Align="Left" VAlign="Top" DataMember="NazwiskoImie" Caption="Nazwisko i imię"></ea:GridColumn>
                    <ea:GridColumn Width="20" Align="Left" VAlign="Top" DataMember="NrWyplaty" Caption="Nr wypłaty"></ea:GridColumn>
                    <ea:GridColumn Align="Left" VAlign="Top" DataMember="Element" Caption="Element" Total="Info"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Przychod" Caption="Przychód" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Koszty" Caption="Koszty uzyskania" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Dochod" Caption="Dochód" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Podatek" Caption="Pobrany podatek" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Zus" Caption="Skł. ub. społeczne odliczona" Total="Sum"></ea:GridColumn>
					<ea:GridColumn Width="10" ID="colZdrowotna1" Align="Right" VAlign="Top" DataMember="Pobrane" Caption="Skł. ub. zdrowotne" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" ID="colZdrowotna2" Align="Right" VAlign="Top" DataMember="Pobrane" Caption="Skł. ub. zdrowotne~pobrana" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" ID="colZdrowotnaDoOdliczenia1" Align="Right" VAlign="Top" DataMember="Odliczone" Caption="Skł. ub. zdrowotne~do odliczenia" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:Grid>
            <br />
            <font face="Tahoma" size="2"><b>PIT 8AR</b></font>
            <ea:Grid id="Grid2" runat="server" DataMember="DataSource" GroupData0="Opis" GroupLine="{0}" ShowGroupSum="true" ColumnTextFontSize="10">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="Lp."></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Left" VAlign="Top" DataMember="Kod" Caption="Kod"></ea:GridColumn>
                    <ea:GridColumn Width="25" Align="Left" VAlign="Top" DataMember="NazwiskoImie" Caption="Nazwisko i imię"></ea:GridColumn>
                    <ea:GridColumn Width="20" Align="Left" VAlign="Top" DataMember="NrWyplaty" Caption="Nr wypłaty"></ea:GridColumn>
                    <ea:GridColumn Align="Left" VAlign="Top" DataMember="Element" Caption="Element" Total="Info"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Przychod" Caption="Przychód" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Koszty" Caption="Koszty uzyskania" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Dochod" Caption="Dochód" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Podatek" Caption="Pobrany podatek" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" VAlign="Top" DataMember="Zus" Caption="Skł. ub. społeczne odliczona" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" ID="colZdrowotna3" Align="Right" VAlign="Top" DataMember="Pobrane" Caption="Skł. ub. zdrowotne" Total="Sum"></ea:GridColumn>
					<ea:GridColumn Width="10" ID="colZdrowotna4" Align="Right" VAlign="Top" DataMember="Pobrane" Caption="Skł. ub. zdrowotne~pobrana" Total="Sum"></ea:GridColumn>
                    <ea:GridColumn Width="10" ID="colZdrowotnaDoOdliczenia2" Align="Right" VAlign="Top" DataMember="Odliczone" Caption="Skł. ub. zdrowotne~do odliczenia" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:Grid>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
